/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.outconn;

import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConnectivityConstants;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.HashMap;

public class OutboundConnectivityBean
extends PanelBean
implements OutboundConnectivityConstants {
    private static final String TRACE_MASKT = "XRCSOCBT";
    private static final String TRACE_MASKF = "XRCSOCBF";
    private static final String TRACE_MASKD = "XRCSOCBD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RCS-OConBean");
    private boolean useServiceAgreement = false;
    private Object[] validateErrorMsgInfo = null;
    private boolean m_bCallHomeServer;

    public void setCallHomeServer(boolean b) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> setCallHomeServer(" + b + ")");
        this.m_bCallHomeServer = b;
        if (this.m_bCallHomeServer && this.useServiceAgreement) {
            if (this.userTaskManager != null) {
                PanelTaskletRequest request = new PanelTaskletRequest();
                request.setSource("OutboundConnectivityBean");
                request.setData("Source", "OutboundConnectivityPanel");
                request.setData("Command", "OpenServiceAgreementPanel");
                this.postTaskletRequest(request);
            }
        } else {
            if (this.userTaskManager != null) {
                TaskActionEvent updateEvent = new TaskActionEvent(this.userTaskManager, this.getBeanName(), "ParentalUpdate");
                this.postParentalAction(updateEvent, this);
            }
            this.updateUTMElements();
        }
        Trace.trace(TRACE_MASKT, "<- setCallHomeServer()");
    }

    public boolean isCallHomeServer() {
        return this.m_bCallHomeServer;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> verifyChanges()");
        Trace.trace(TRACE_MASKT, "<- verifyChanges()");
    }

    public void load() {
        Trace.trace(TRACE_MASKT, "-> load()");
        Trace.trace(TRACE_MASKT, "<- load()");
    }

    public void save() {
        Trace.trace(TRACE_MASKT, "-> save()");
        Trace.trace(TRACE_MASKT, "<- save()");
    }

    public void setValidateErrorMsgInfo(Object[] msgInfo) {
        Trace.trace(TRACE_MASKT, "<> setValidateErrorMsgInfo(" + msgInfo + ")");
        this.validateErrorMsgInfo = msgInfo;
    }

    public void setUseServiceAgreement(boolean b) {
        Trace.trace(TRACE_MASKT, "<> setUseServiceAgreement(" + b + ")");
        this.useServiceAgreement = b;
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, "-> prepare()");
        this.updateDataBeanInfo(true);
        this.updateUTMElements();
        Trace.trace(TRACE_MASKT, "<- prepare()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void panelAction(TaskActionEvent event) {
        block11: {
            Trace.trace(TRACE_MASKT, "-> panelAction(" + event + ")");
            try {
                String element = event.getElementName();
                if (element.endsWith("OkButton")) {
                    try {
                        this.userTaskManager.storeAllElements();
                        TaskActionEvent validateEvent = new TaskActionEvent(this.userTaskManager, this.getBeanName(), "ParentalValidate");
                        this.postParentalAction(validateEvent, this);
                        if (this.validateErrorMsgInfo != null) {
                            try {
                                try {
                                    LocalizableText title = (LocalizableText)this.validateErrorMsgInfo[0];
                                    MessageText text = (MessageText)this.validateErrorMsgInfo[1];
                                    CommonMsgApp.showMessageBox(this.userTaskManager, title, text);
                                }
                                catch (Exception e) {
                                    new FrameworkLog(classLogInfo, 1941, e).log();
                                    this.dispose();
                                    Object var7_12 = null;
                                    this.validateErrorMsgInfo = null;
                                    break block11;
                                }
                                Object var7_11 = null;
                                this.validateErrorMsgInfo = null;
                                break block11;
                            }
                            catch (Throwable throwable) {
                                Object var7_13 = null;
                                this.validateErrorMsgInfo = null;
                                throw throwable;
                            }
                        }
                        TaskActionEvent commitEvent = new TaskActionEvent(this.userTaskManager, this.getBeanName(), "ParentalCommit");
                        this.postParentalAction(commitEvent, this);
                        PanelTaskletRequest request = new PanelTaskletRequest();
                        request.setSource("OutboundConnectivityBean");
                        request.setData("Source", "OutboundConnectivityPanel");
                        request.setData("Command", "Commit");
                        request.setData("Bean", this);
                        this.postTaskletRequest(request);
                    }
                    catch (IllegalUserDataException iude) {}
                    break block11;
                }
                if (element.endsWith("CancelButton")) {
                    this.dispose();
                }
            }
            catch (RuntimeException rte) {
                new FrameworkLog(classLogInfo, 1941, rte).log();
                this.dispose();
            }
        }
        Trace.trace(TRACE_MASKT, "<- panelAction()");
    }

    public void update(Object newData) {
        Trace.trace(TRACE_MASKT, "-> update()");
        try {
            HashMap data = (HashMap)newData;
            String command = (String)data.get("Command");
            if (command == null) {
                command = "";
            }
            Trace.trace(TRACE_MASKF, "command=" + command);
            if (command.equals("")) {
                Trace.trace(TRACE_MASKF, "Unspecified command");
            } else if (command.equals("DisableCallHome")) {
                this.m_bCallHomeServer = false;
                TaskActionEvent updateEvent = new TaskActionEvent(this.userTaskManager, this.getBeanName(), "ParentalUpdate");
                this.postParentalAction(updateEvent, this);
                this.updateUTMElements();
            } else if (command.equals("EnableCallHome")) {
                this.m_bCallHomeServer = true;
                TaskActionEvent updateEvent = new TaskActionEvent(this.userTaskManager, this.getBeanName(), "ParentalUpdate");
                this.postParentalAction(updateEvent, this);
                this.updateUTMElements();
            } else if (command.equals("DisplayMsg")) {
                try {
                    String msgId = (String)data.get("MsgId");
                    LocalizableText title = new LocalizableText("com.ibm.hwmca.fw.rcs.outconn.res.OutboundConnMsgs", msgId + ".TITLE");
                    MessageText text = new MessageText("com.ibm.hwmca.fw.rcs.outconn.res.OutboundConnMsgs", msgId + ".MSG");
                    CommonMsgApp.showMessageBox(this.userTaskManager, title, text);
                }
                catch (Exception e) {
                    new FrameworkLog(classLogInfo, 1941, e).log();
                    this.dispose();
                }
            } else {
                Trace.trace(TRACE_MASKF, "Unknown command");
            }
        }
        catch (RuntimeException rte) {
            new FrameworkLog(classLogInfo, 1941, rte).log();
            this.dispose();
        }
        Trace.trace(TRACE_MASKT, "<- update()");
    }

    private void updateDataBeanInfo(boolean initialUpdate) {
        Trace.trace(TRACE_MASKT, "-> updateDataBeanInfo(" + initialUpdate + ")");
        Trace.trace(TRACE_MASKT, "<- updateDataBeanInfo()");
    }

    private void updateUTMElements() {
        Trace.trace(TRACE_MASKT, "-> updateUTMElements()");
        if (this.userTaskManager != null) {
            String prefix = this.getMountPrefix();
            if (this.m_bCallHomeServer) {
                this.userTaskManager.setSelected(prefix + "CallHomeServerCheckbox", true);
            } else {
                this.userTaskManager.setSelected(prefix + "CallHomeServerCheckbox", false);
            }
            this.userTaskManager.refreshElement(prefix + "CallHomeServerCheckbox");
        }
        Trace.trace(TRACE_MASKT, "<- updateUTMElements()");
    }
}

